<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use CTemplateDynamic;


class ShortcodeBase {
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = null;
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = null;

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = null;
	var $sample_usage = null;
	

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $tpl = null;
		

	public static function newInstance() {
		return new static();
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getPath() {
		global $_ADMIN;


		$path = strtolower(str_replacE("\\" , "/" , __NAMESPACE__) . "/" . $this->name);

		if ($_ADMIN) {
			return str_replace("stembase/" , "" , $path);
		} else {
			return str_replace("stembase/" , "admin/" , $path);
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getName() {
		return $this->name;
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function loadTemplate() {

		if (!is_object($this->tpl)) {
			$this->tpl = new CTemplateDynamic($this->getPath() . ".htm");
		}
		

	}	
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	public function getMeta($help = false) {

		if (!$help) {
			return array(
				"name"		=> $this->name,
				"version"	=> $this->version,
				"class"		=> get_class($this)
			);
		} else {
			return array(
				"name"		=> $this->name,
				"version"	=> $this->version,
				"class"		=> get_class($this),
				"sample"	=> $this->sample_usage,
				"attributes"=> $this->sample_attributes,
			);

		}		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	public function Render($data) {
	}

	public function getBackground($val, $prop = "background") {
		global $_MODULES;

		if (!$val) {
			return array(
				"bg_class"		=> "",
				"bg_html"		=> "",
				"bg_style"		=> "",					
				"bg_scheme"		=> "{BG:SCHEME}",
			);
		}

		if ($val == "transparent") {
			return array(
				"bg_class"		=> "",
				"bg_html"		=> "",
				"bg_style"		=> "transparent",					
				"bg_scheme"		=> "",
			);
		}
		
		

		//id of the background from the backfrounds module
		if (strstr($val , "bg-")) {
			$id = str_replace("bg-" , "" , $val);

			$bg = $_MODULES["backgrounds"]->getBg($id);

			return array(
				"bg_class"		=> $bg["class"] . " " . $bg["bg:scheme"],
				"bg_html"		=> $bg["html"],
				"bg_style"		=> "",					
				"bg_scheme"		=> $bg["bg:scheme"],
			);
		}

		//hexa code
		if ((strlen($val) == "7" || strlen($val) == "4") && strstr($val , "#")) {

			return array(
				"bg_class"		=> "",
				"bg_html"		=> "",
				"bg_style"		=> "{$prop}: {$val}; ",					
				"bg_scheme"		=> "{BG:SCHEME}",
			);
		}

		//gradient
		if (stristr($val , "gradient")) {
			$tmp = str_ireplace("gradient(" , "" , str_replace(")" , "" , $val));

			return array(
				"bg_class"		=> "",
				"bg_html"		=> "",
				"bg_style"		=> "{$prop}: linear-gradient({$tmp});",					
				"bg_scheme"		=> "{BG:SCHEME}",
			);
		}
		
		
		//cant idetingy the background
		return array(
			"bg_class"		=> "",
			"bg_html"		=> "",
			"bg_style"		=> "",					
			"bg_scheme"		=> "{BG:SCHEME}",
		);

		//debug($val,1);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getSize($value , $sep = ";") {

		if (stristr($value , "%")) {
			return $value . $sep;
		}

		if (stristr($value , "px")) {
			return $value . $sep;
		}

		if (stristr($value , "rem")) {
			return $value . $sep;
		}

		if (stristr($value , "em")) {
			return $value . $sep;
		}

		if (stristr($value , "vh")) {
			return $value . $sep;
		}

		if (stristr($value , "")) {
			return $value . $sep;
		}



		return $value . "px" . $sep;
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CSSClass($class) {
		return str_replace("&nbsp;" , " " , $class);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function buildShortcode($code , $attrs = array(), $content = "") {

		if (is_array($attrs) && count($attrs)) {
			foreach ($attrs as $key => $val) {
				if (!$val) {
					unset($attrs[$key]);
				}				
			}	

			if (count($attrs)) {
				foreach ($attrs as $key => $val) {
					$_attrs .= " {$key}=\"" . $val . "\" ";
				}				
			}			
		}

		if ($content) {
			return "[{$code} {$_attrs}]{$content}[/{$code}]";
		}

		return "[{$code} {$_attrs}/]";
		
	}
	
	
}